function force_error = zero_delta_force_function(force, clutch_extension, substrate_stiffness, total_N_rigid, globular_domain_size, total_wormlike_contour, kT, L_p)

% Program claculates deviation of the force predicted for FJC of folded
% domains from the force calculated for disordered WLC part of clutches

% extension - scalar
% force - can be an array

force_error = 10000 * ones( size(force, 1), size(force, 2) );

z = globular_domain_size * force / kT;
extension_folded_domains = total_N_rigid * globular_domain_size * ( coth(z) - 1./z );
extension_substrate = force / substrate_stiffness;
delta_extension = clutch_extension - extension_folded_domains - extension_substrate;
relative_extension_WLC = abs(delta_extension) / total_wormlike_contour;
force_WLC = kT / L_p * sign(delta_extension) .* ( relative_extension_WLC + 0.25 ./ (1 - relative_extension_WLC).^2 - 0.25 );
indexes = (relative_extension_WLC < 0.9999);
force_error(indexes) = force(indexes) - force_WLC(indexes);

end

